/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import java.io.FileNotFoundException;
import java.io.IOException;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.MmdMotionPlayerGL2;
import jp.nyatla.nymmd.MmdPmdModelMc;
import jp.nyatla.nymmd.MmdPmdModel_BasicClass;
import jp.nyatla.nymmd.MmdVmdMotionMc;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.BladeMotionManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.event.client.UserPoseOverrider;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

public class LayerMainBlade<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    final LazyOptional<MmdPmdModelMc> bladeholder = LazyOptional.of(() -> {
        try {
            return new MmdPmdModelMc(new ResourceLocation("slashblade", "model/bladeholder.pmd"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MmdException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    });
    final LazyOptional<MmdMotionPlayerGL2> motionPlayer = LazyOptional.of(() -> {
        MmdMotionPlayerGL2 mmp = new MmdMotionPlayerGL2();
        this.bladeholder.ifPresent(pmd -> {
            try {
                mmp.setPmd((MmdPmdModel_BasicClass)pmd);
            }
            catch (MmdException e) {
                e.printStackTrace();
            }
        });
        return mmp;
    });

    public LayerMainBlade(RenderLayerParent<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public float modifiedSpeed(float baseSpeed, LivingEntity entity) {
        float modif = 6.0f;
        if (MobEffectUtil.m_19584_((LivingEntity)entity)) {
            modif = 6 - (1 + MobEffectUtil.m_19586_((LivingEntity)entity));
        } else if (entity.m_21023_(MobEffects.f_19599_)) {
            modif = 6 + (1 + entity.m_21124_(MobEffects.f_19599_).m_19564_()) * 2;
        }
        return baseSpeed / (modif /= 6.0f);
    }

    public void renderOffhandItem(PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, T entity) {
        ItemStack offhandStack = entity.m_21120_(InteractionHand.OFF_HAND);
        if (offhandStack.m_41619_() || !offhandStack.getCapability(CapabilitySlashBlade.BLADESTATE).isPresent()) {
            this.renderHotbarItem(matrixStack, bufferIn, lightIn, entity);
            return;
        }
        this.renderStandbyBlade(matrixStack, bufferIn, lightIn, offhandStack);
    }

    public void renderHotbarItem(PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, T entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150109_().f_35977_ == 0) {
                return;
            }
            ItemStack blade = player.m_150109_().m_8020_(0);
            if (blade.m_41619_()) {
                return;
            }
            this.renderStandbyBlade(matrixStack, bufferIn, lightIn, blade);
        }
    }

    public void renderStandbyBlade(PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, ItemStack blade) {
        LazyOptional state = blade.getCapability(CapabilitySlashBlade.BLADESTATE);
        state.ifPresent(s -> {
            double modelScaleBase = 0.0078125;
            double motionScale = 0.125;
            ResourceLocation textureLocation = s.getTexture().orElse(DefaultResources.resourceDefaultTexture);
            WavefrontObject obj = BladeModelManager.getInstance().getModel(s.getModel().orElse(DefaultResources.resourceDefaultModel));
            try (MSAutoCloser msacA = MSAutoCloser.pushMatrix(matrixStack);){
                matrixStack.m_252880_(0.0f, 1.5f, 0.0f);
                CarryType carrytype = s.getCarryType();
                switch (carrytype) {
                    case PSO2: {
                        matrixStack.m_252880_(1.0f, -1.125f, 0.2f);
                        matrixStack.m_252781_(new Quaternionf().rotateZYX(-0.122173f, 0.0f, 0.0f));
                        break;
                    }
                    case KATANA: {
                        matrixStack.m_252880_(0.25f, -0.875f, -0.75f);
                        matrixStack.m_252781_(new Quaternionf().rotateZYX((float)Math.PI, 1.570796f, 0.261799f));
                        break;
                    }
                    case DEFAULT: {
                        matrixStack.m_252880_(0.25f, -0.875f, -0.75f);
                        matrixStack.m_252781_(new Quaternionf().rotateZYX(0.0f, 1.570796f, 0.261799f));
                        break;
                    }
                    case NINJA: {
                        matrixStack.m_252880_(-0.5f, -2.0f, 0.2f);
                        matrixStack.m_252781_(new Quaternionf().rotateZYX(-2.094395f, 0.0f, (float)Math.PI));
                        break;
                    }
                    case RNINJA: {
                        matrixStack.m_252880_(0.5f, -2.0f, 0.2f);
                        matrixStack.m_252781_(new Quaternionf().rotateZYX(-1.047198f, 0.0f, 0.0f));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                matrixStack.m_85841_((float)motionScale, (float)motionScale, (float)motionScale);
                matrixStack.m_85841_(modelScale, modelScale, modelScale);
                try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack);){
                    String part = s.isBroken() ? "blade_damaged" : "blade";
                    BladeRenderState.renderOverrided(blade, obj, part, textureLocation, matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverridedLuminous(blade, obj, part + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverrided(blade, obj, "sheath", textureLocation, matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverridedLuminous(blade, obj, "sheath_luminous", textureLocation, matrixStack, bufferIn, lightIn);
                }
            }
        });
    }

    public void render(PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderOffhandItem(matrixStack, bufferIn, lightIn, entity);
        float motionYOffset = 1.5f;
        double motionScale = 0.125;
        double modelScaleBase = 0.0078125;
        ItemStack stack = entity.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41619_()) {
            return;
        }
        LazyOptional state = stack.getCapability(CapabilitySlashBlade.BLADESTATE);
        state.ifPresent(s -> this.motionPlayer.ifPresent(mmp -> {
            double time;
            ComboState combo = ComboStateRegistry.REGISTRY.get().getValue(s.getComboSeq()) != null ? (ComboState)ComboStateRegistry.REGISTRY.get().getValue(s.getComboSeq()) : (ComboState)ComboStateRegistry.NONE.get();
            for (time = TimeValueHelper.getMSecFromTicks((float)Math.max(0L, entity.m_9236_().m_46467_() - s.getLastActionTime()) + partialTicks); combo != ComboStateRegistry.NONE.get() && (double)combo.getTimeoutMS() < time; time -= (double)combo.getTimeoutMS()) {
                combo = ComboStateRegistry.REGISTRY.get().getValue(combo.getNextOfTimeout((LivingEntity)entity)) != null ? (ComboState)ComboStateRegistry.REGISTRY.get().getValue(combo.getNextOfTimeout((LivingEntity)entity)) : (ComboState)ComboStateRegistry.NONE.get();
            }
            if (combo == ComboStateRegistry.NONE.get()) {
                combo = ComboStateRegistry.REGISTRY.get().getValue(s.getComboRoot()) != null ? (ComboState)ComboStateRegistry.REGISTRY.get().getValue(s.getComboRoot()) : (ComboState)ComboStateRegistry.STANDBY.get();
            }
            MmdVmdMotionMc motion = BladeMotionManager.getInstance().getMotion(combo.getMotionLoc());
            double maxSeconds = 0.0;
            try {
                mmp.setVmd(motion);
                maxSeconds = TimeValueHelper.getMSecFromFrames(motion.getMaxFrame());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            double start = TimeValueHelper.getMSecFromFrames(combo.getStartFrame());
            double end = TimeValueHelper.getMSecFromFrames(combo.getEndFrame());
            double span = Math.abs(end - start);
            span = Math.min(maxSeconds, span);
            if (combo.getLoop()) {
                time %= span;
            }
            time = Math.min(span, time);
            time = start + time;
            try {
                mmp.updateMotion((float)time);
            }
            catch (MmdException e) {
                e.printStackTrace();
            }
            try (MSAutoCloser msacA = MSAutoCloser.pushMatrix(matrixStack);){
                PoseStack.Pose entry;
                Matrix4f mat;
                int idx;
                this.setUserPose(matrixStack, entity, partialTicks);
                matrixStack.m_252880_(0.0f, motionYOffset, 0.0f);
                matrixStack.m_85841_((float)motionScale, (float)motionScale, (float)motionScale);
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                ResourceLocation textureLocation = s.getTexture().orElse(DefaultResources.resourceDefaultTexture);
                WavefrontObject obj = BladeModelManager.getInstance().getModel(s.getModel().orElse(DefaultResources.resourceDefaultModel));
                try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack);){
                    idx = mmp.getBoneIndexByName("hardpointA");
                    if (0 <= idx) {
                        float[] buf = new float[16];
                        mmp._skinning_mat[idx].getValue(buf);
                        mat = VectorHelper.matrix4fFromArray(buf);
                        matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                        entry = matrixStack.m_85850_();
                        entry.m_252922_().mul((Matrix4fc)mat);
                        matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                    }
                    float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                    matrixStack.m_85841_(modelScale, modelScale, modelScale);
                    String part = s.isBroken() ? "blade_damaged" : "blade";
                    BladeRenderState.renderOverrided(stack, obj, part, textureLocation, matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverridedLuminous(stack, obj, part + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
                }
                msac = MSAutoCloser.pushMatrix(matrixStack);
                try {
                    idx = mmp.getBoneIndexByName("hardpointB");
                    if (0 <= idx) {
                        float[] buf = new float[16];
                        mmp._skinning_mat[idx].getValue(buf);
                        mat = VectorHelper.matrix4fFromArray(buf);
                        matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                        entry = matrixStack.m_85850_();
                        entry.m_252922_().mul((Matrix4fc)mat);
                        matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                    }
                    float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                    matrixStack.m_85841_(modelScale, modelScale, modelScale);
                    BladeRenderState.renderOverrided(stack, obj, "sheath", textureLocation, matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverridedLuminous(stack, obj, "sheath_luminous", textureLocation, matrixStack, bufferIn, lightIn);
                    if (s.isCharged((LivingEntity)entity)) {
                        float f = (float)entity.f_19797_ + partialTicks;
                        BladeRenderState.renderChargeEffect(stack, f, obj, "effect", new ResourceLocation("textures/entity/creeper/creeper_armor.png"), matrixStack, bufferIn, lightIn);
                    }
                }
                finally {
                    if (msac != null) {
                        msac.close();
                    }
                }
            }
        }));
    }

    public void setUserPose(PoseStack matrixStack, T entity, float partialTicks) {
        if (!UserPoseOverrider.UsePoseOverrider && entity instanceof AbstractClientPlayer) {
            AnimationApplier animationPlayer = ((IAnimatedPlayer)entity).playerAnimator_getAnimation();
            animationPlayer.setTickDelta(partialTicks);
            if (animationPlayer.isActive()) {
                Vec3f vec3d = animationPlayer.get3DTransform("body", TransformType.POSITION, Vec3f.ZERO);
                matrixStack.m_85837_((double)(-((Float)vec3d.getX()).floatValue()), (double)((Float)vec3d.getY()).floatValue() + 0.7, (double)(-((Float)vec3d.getZ()).floatValue()));
                Vec3f vec3f = animationPlayer.get3DTransform("body", TransformType.ROTATION, Vec3f.ZERO);
                matrixStack.m_252781_(Axis.f_252403_.m_252961_(((Float)vec3f.getZ()).floatValue()));
                matrixStack.m_252781_(Axis.f_252436_.m_252961_(((Float)vec3f.getY()).floatValue()));
                matrixStack.m_252781_(Axis.f_252529_.m_252961_(((Float)vec3f.getX()).floatValue()));
                matrixStack.m_85837_(0.0, -0.7, 0.0);
            }
        } else {
            UserPoseOverrider.invertRot(matrixStack, entity, partialTicks);
        }
    }
}

